#define MANIFEST_VERSION "0.2"
/*
 * This is a very simple version of umsmanifest running under MSDOS
 * to create a "manifest" for a directory from a Umsdos File System.
 * Once created, the "manifest" shell script allow to restore the
 * original name for all the file discribe in the "--linux-.---" file.
 *
 * It is made to fake the fonctionality of the original umsmanifest under
 * LINUX made by Glaude David [Glu] dglaude@ulb.ac.be (Hey that's ME).
 *
 * If it detect no "--linux-.---" or find argument that he can't
 *  handel, it produce no output.
 * For the moment, only work within current disk.
 *
 * Please report any Bug to: GLAUDE DAVID (dglaude@is1.ulb.ac.be) [Glu]
 *
 * The only todo I have on my list for this program is a recursive version,
 *  with automatique creation of a manifest in each directory.
 * Please send me a short email with comments if you use it often.
 * Please e-mail me for "I really want to pay this men even if it's free.".
 */

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <string.h>

#define VERSION_MSDOS
#include "dosumsfs.h"
#include "msmangle.h"
#include "dirent.h"
#include "group.h"

struct ffblk ffblk;

/* Verifie la presence d'un fichier sous MsDos */
struct ffblk *infomsdos(char *msdosname)
{
return (findfirst(msdosname,&ffblk,
	FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH)==0)?&ffblk:NULL;
}

int display_linux_info(struct ffblk *ffblk,
		       struct dirent *entry)
{
char msdosname[20];
int length, i;

length = strlen(ffblk->ff_name);
for (i=0; i<=length; i++)
 msdosname[i] = tolower(ffblk->ff_name[i]);

 if (strcmp(msdosname,entry->entry.name))
  printf("mv %s %s\n",msdosname,entry->entry.name);
 return 1;
}


int select(struct dirent *entry)
{
if((entry->entry.flags)&UMSDOS_HIDDEN) 				return 0;
return 1;
}

int linuxdir(char *dirfile)
{
struct ffblk *ffblk;
struct dirent ***namelist;
int nbr,i;

/* Scan the directory DIR, calling SELECT on each directory entry.
   Entries for which SELECT returns nonzero are individually malloc'd
   and collected in a malloc'd array in *NAMELIST.
   Returns the number of entries selected, or -1 on error.  */

 nbr=scandir(dirfile,namelist,select,NULL);

 if (nbr>=0){
	for(i=0;i<nbr;i++){
		if((ffblk=infomsdos(namelist[0][i]->fake.fname))!=NULL){
			display_linux_info(ffblk, namelist[0][i]);
		}
		free(namelist[0][i]);
	}
/*	free(namelist);		*/
/* There is a bug somewhere !!! Cause I get Null Pointer Assignement if
   I do not comment this line out */
/* The BUG must be in dirent.c in this complicate sheme of allocation ! */
/* One Beer to the one that found it. ;-) */
 }

 return nbr;
}

int main (int argc, char *argv[])
{
 char buffer[MAXPATH];

 if (argc!=2)
  {
  printf("MANIFEST.EXE to create a shell script that restore names for files\n"
	 "from an UMSDOS File Systeme.\n"
	 "Made by Glaude David (dglaude@is1.ulb.ac.be) [Glu]\n"
	 "A lot of code taken from UMSDOS FS made by Jacques Gelinas\n"
	 "Some code hacked from The GNU C Library\n"
	 "This is UMSmanifest Version " MANIFEST_VERSION "\n"
	 "Made for UMSDOS Version %d.%d\n"
	 "\n"
	 "Usage: manifest directory > manifest\n",
	 UMSDOS_VERSION,UMSDOS_RELEASE);
  return 1;
  }

 getcwd(buffer, MAXPATH);
 if (chdir(argv[1]))
 {
  perror("chdir()");
  exit(1);
 }

 linuxdir(UMSDOS_EMD_FILE);

 if (chdir(buffer))
  {
  perror("chdir()");
  exit(1);
  }
 return 0;
}

